﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker2.Writer.Implementation.Concrete.EVS;
using BMS.VistaIntegration.Data;
using BMS.VistaWorker2.Writer.Implementation.Concrete.EIS;
using BMS.VistaWorker2.Writer.Implementation.Concrete.WF;
using BMS.VistaWorker2.Writer.Implementation.Concrete.WaitingList;
using BMS.VistaIntegration.Data.WaitingList;
using BMS.VistaWorker2.Writer.Implementation.Concrete;

namespace BMS.VistaWorker2.Writer.Implementation
{
    /// <summary>
    /// Writer manager factory - creates an underlying writer manager.
    /// </summary>
    public class WriterManagerFactory : IWriterManagerFactory
    {
        static WriterManagerFactory()
        {
            CreateWritersForEis();
            CreateWritersForEvs();
            CreateWritersForWorkFlow();
            CreateWritersForWaitingList();
        }

        private static void Add<T, V>()
            where T : BaseEntityWriter<V>, new()
        {
            WriterManager.Add<T, V>();
        }


        private static void CreateWritersForWaitingList()
        {
            Add<WaitingListItemWriter, WaitingListItem>();
        }

        private static void CreateWritersForEis()
        {
            Add<NewPersonWriter, NewPerson>();
            Add<HospitalLocationWriter, HospitalLocation>();
            Add<RoomBedWriter, RoomBed>();
            Add<WardLocationWriter, WardLocation>();
            Add<PatientWriter, Patient>();

        }

        private static void CreateWritersForEvs()
        {
            Add<OrderableItemWriter, OrderableItem>();
            Add<SpecialtyWriter, Specialty>();
            Add<TreatingSpecialtyWriter, FacilityTreatingSpecialty>();
            Add<TypeOfMovementWriter, FacilityMovementType>();
            Add<MedicalCenterDivisionWriter, MedicalCenterDivision>();

        }

        private static void CreateWritersForWorkFlow()
        {
            Add<OrderWriter, OrderAction>();
            Add<PatientAppointmentWriter, PatientAppointment>();
            Add<PatientMovementWriter, PatientMovement>();
            Add<ScheduledAdmissionWriter, ScheduledAdmission>();
        }

        /// <summary>
        /// Creates the writer manager.
        /// </summary>
        /// <returns></returns>
        public IWriterManager MakeWriter()
        {
            return new WriterManager();
        }
    }
}
